local assets =
{
	Asset("ANIM", "anim/tf2wrench.zip"),
	Asset("ANIM", "anim/swap_tf2wrench.zip"),

	Asset("ATLAS", "images/inventoryimages/tf2wrench.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2wrench.tex"),
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_tf2wrench", "tf2wrench")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
	
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
	end

    inst:AddTag("dull")
    --inst:AddTag("metal")

    inst.AnimState:SetBank("tf2wrench")
    inst.AnimState:SetBuild("tf2wrench")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("upgrade")

    --inst:AddComponent("tool")
    --inst.components.tool:SetAction(ACTIONS.HAMMER)

    inst:AddComponent("inspectable")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.TF2WRENCH_DAMAGE)

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "tf2wrench"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tf2wrench.xml"

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.TF2WRENCH_USES)
    inst.components.finiteuses:SetUses(TUNING.TF2WRENCH_USES)
    inst.components.finiteuses:SetConsumption(ACTIONS.ENGIEWORK, 1)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    return inst
end

return Prefab("common/inventory/tf2wrench", fn, assets)